//
//  font2d.fx
//  for Empathy engine projects
//
//  Created by Thom Robertson on 9/7/2013.
//

//*************************************************************************
// these 4 sampler values are the 4 possible textures that are set seperatly
sampler s0; 
sampler s1; 
sampler s2; 
sampler s3; 

//*************************************************************************
// these 4 float3 values CAN be passed in by EmpathyGraphicsDX9::Flush()
float3 dir_pos0;
float3 dir_pos1;
float3 dir_pos2;
float3 dir_pos3;

//*************************************************************************
// these 4 float4 values CAN be passed in by EmpathyGraphicsDX9::Flush()
float4 color0;
float4 color1;
float4 color2;
float4 color3;

//*************************************************************************
// these 12 float values CAN be passed in by EmpathyGraphicsDX9::Flush()
float materialValue0; 
float materialValue1; 
float materialValue2; 
float materialValue3; 
float materialValue4; 
float materialValue5; 
float materialValue6; 
float materialValue7; 
float materialValue8; 
float materialValue9; 
float materialValue10; 
float materialValue11; 


//*************************************************************************
struct VS_INPUT
{
	float4 Position  : POSITION0;
	float2 TexCoord  : TEXCOORD0;
	float4 Color     : TEXCOORD1;
};
//*************************************************************************
struct VS_OUTPUT
{
	float4 Position  : POSITION0;
	float4 Color     : COLOR0;
	float2 TexCoord  : TEXCOORD0;
};

//*************************************************************************
VS_OUTPUT vs_main(VS_INPUT Input)
{
	VS_OUTPUT Output;
	Output.Position = Input.Position;
	Output.Color    = Input.Color;
	Output.TexCoord = Input.TexCoord;
	return Output;
}

//*************************************************************************
float4 PixelShaderFunction(VS_OUTPUT Input) : COLOR0  
{  
	float4 color = tex2D(s0, Input.TexCoord.xy) * Input.Color;  
	return color;  
} 

//*************************************************************************
technique Main 
{
	pass p0 
	{
	    MinFilter[0] = Point; 
        MagFilter[0] = Point;
        MipFilter[0] = Point;
         
		CullMode = None;
		VertexShader  = compile vs_2_0 vs_main();
		PixelShader   = compile ps_2_0 PixelShaderFunction();
	}
}
