float4x4 wvp : WorldViewProjection;
float4x4 world : World;

float3 CameraPosition : CameraPosition; 

float AmbientIntensity = 1;
float4 AmbientColor : AMBIENT = float4(0.1,0.1,0.1,1);

float3 LightDirection : Direction = float3(0,1,1);

sampler2D tex0;

struct VS_IN
{
	float4 Position : POSITION;
	float2 TexCoord : TEXCOORD0;
	float3 Normal : NORMAL;	
};

struct VS_OUT
{
	float4 Position : POSITION;
	float2 TexCoord : TEXCOORD0;
    float3 Normal :TEXCOORD1;	
};

struct PS_OUT
{
	float4 Color : COLOR;
};

//------------------------------------------------------------------------------------------
VS_OUT VS_Color(VS_IN input)
{
	VS_OUT output = (VS_OUT)0;
	
	output.Position = mul(input.Position,wvp);	
	output.TexCoord = input.TexCoord;
  
	output.Normal = mul(input.Normal,world);
	
	return output;
}
//------------------------------------------------------------------------------------------
PS_OUT PS_Color(VS_OUT input)
{
	PS_OUT output = (PS_OUT)0;
	
	float Diffuse = saturate(dot(normalize(LightDirection),normalize(input.Normal)));
		
	float4 texCol = tex2D(tex0, input.TexCoord);
	
    texCol *= Diffuse;

	output.Color =  AmbientColor + texCol;
	
	return output;
}

//------------------------------------------------------------------------------------------
technique Color
{
	pass Pass0
	{
		VertexShader = compile vs_2_0 VS_Color();
		PixelShader = compile ps_2_0 PS_Color();
	}
}